<!DOCTYPE html>
<html <?php language_attributes(); ?>>

    <head>
        <meta charset="<?php bloginfo('charset'); ?>" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <!--<link rel="stylesheet" href="http://maxcdn.bootstrapcdn.com/bootstrap/3.2.0/css/bootstrap.min.css">-->

        <?php if (is_search()) { ?>
            <meta name="robots" content="noindex, nofollow" /> 
        <?php } ?>

        <title>
            <?php
            if (function_exists('is_tag') && is_tag()) {
                single_tag_title("Tag Archive for &quot;");
                echo '&quot; - ';
            } elseif (is_archive()) {
                wp_title('');
                echo ' Archive - ';
            } elseif (is_search()) {
                echo 'Search for &quot;' . wp_specialchars($s) . '&quot; - ';
            } elseif (!(is_404()) && (is_single()) || (is_page())) {
                wp_title('');
                echo ' - ';
            } elseif (is_404()) {
                echo 'Not Found - ';
            }
            if (is_home()) {
                bloginfo('name');
                echo ' - ';
                bloginfo('description');
            } else {
                bloginfo('name');
            }
            if ($paged > 1) {
                echo ' - page ' . $paged;
            }
            ?>
        </title>

        <link rel="shortcut icon" href="/favicon.ico">

        <link rel="stylesheet" href="<?php bloginfo('stylesheet_url'); ?>">

        <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/css/home.css">
        <?php if (is_page_template('products.php')) { ?>
            <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/css/product.css">
        <?php } ?>

        <?php if (is_page_template('categories.php')) { ?>
            <link rel="stylesheet" href="<?php bloginfo('template_url'); ?>/css/category.css">
        <?php } ?>

        <link rel="pingback" href="<?php bloginfo('pingback_url'); ?>">

        <?php if (is_singular()) wp_enqueue_script('comment-reply'); ?>

        <?php wp_head(); ?>
          <script src="https://ajax.googleapis.com/ajax/libs/jquery/1.11.3/jquery.min.js"></script>
        <script src="<?php bloginfo('template_url'); ?>/js/jquery.hoverflow.min.js"></script>
        <script src="<?php bloginfo('template_url'); ?>/js/actegypt.js"></script>
   

    </head>

    <body <?php body_class(); ?>>

        <div id="page-wrap" class="group">
       
            <header>
            
              <div id="logo"><a href="http://www.actegypt.com"><img src="/wp-content/themes/actegypt-theme/images/act-logo.png"></a></div>

                <h1 style="display:none;"><a href="<?php echo get_option('home'); ?>/"><?php bloginfo('name'); ?></a></h1>
                <span></span>
                <p><?php bloginfo('description'); ?></p>
               
            </header>
            
          
            <div id="main-content">
             <!--<div class='container'><div class='row'>-->